//
//  CRCIImageManager.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 7/18/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRCIImageDescriptor;

//////////////////////////////////////////////////////////////////////
// Images manager
//////////////////////////////////////////////////////////////////////
@interface CRCIImageManager : NSObject
{
	NSLock*                 lock;
	NSInteger				collectorState;
	NSCondition*			collectorCondition;
	NSMutableDictionary*	images;
	NSMutableArray*			initiallyReferenced; // see comments in decodePathDataWithCoder:forKey:
}

+ (CRCIImageManager *)sharedManager;

- (void)dispose;
- (CIImage *)loadImageWithPath:(NSString *)path size:(NSSize)requestedSize;
- (void)unloadImage:(CIImage *)anImage;

- (void)encodeDataForPath:(NSString *)path withCoder:(NSCoder *)coder toKey:(NSString *)key;
- (NSString *)decodePathDataWithCoder:(NSCoder *)coder forKey:(NSString *)key;

@end